//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Net;
using System.Text;
using System.IO;
using System.Collections.Specialized;

namespace HTMLViewer
{
	/// <summary>
	/// Podsumowanie dla HTMLPageGet.
	/// </summary>
	public class HTMLPageGet
	{
		public enum SourceType
		{
			Unknown = 0,
			Html,
			File
		}

		private WebRequest request;
		private WebResponse response;
		private StringBuilder strSource = new StringBuilder();
		public HTMLPageGet(string url)
		{
			try
			{
				request = WebRequest.Create(url);
				response = request.GetResponse();
				// Uzyskanie strumienia danych
				StreamReader sr = new StreamReader(response.GetResponseStream(), Encoding.ASCII);
				string strTemp;
				while ((strTemp = sr.ReadLine()) != null)
				{
					strSource.Append(strTemp + "\r\n");					
				}
				sr.Close();
				if(request is HttpWebRequest)
				{
					HttpWebRequest httpRequest = (HttpWebRequest)request;
				}
				else if(request is FileWebRequest)
				{
					FileWebRequest fileRequest = (FileWebRequest)request;
				}
			}
			catch (WebException ex) 
			{
				strSource.Append(ex.Message);
			}			
		}
		public string Source
		{
			get
			{
				return strSource.ToString();
			}
		}
		public SourceType Type
		{
			get
			{
				if(request is HttpWebRequest)
				{
					return SourceType.Html;
				}
				else if(request is FileWebRequest)
				{
					return SourceType.File;
				}
				else
				{
					return SourceType.Unknown;
				}
			}
		}
		public NameValueCollection SourceProperties
		{
			get
			{
				NameValueCollection c = new NameValueCollection();

				if(response is HttpWebResponse)
				{
					HttpWebResponse r = (HttpWebResponse)response;
					c.Add("Address", r.ResponseUri.AbsoluteUri);
					c.Add("CharacterSet", r.CharacterSet);
					c.Add("Cookies", Convert.ToString(r.Cookies.Count));
					c.Add("ContentEncoding", r.ContentEncoding);
					c.Add("ContentLength", Convert.ToString(r.ContentLength));
					c.Add("ContentType", r.ContentType);
					c.Add("LastModified", Convert.ToString(r.LastModified));
					c.Add("Method", r.Method);
					c.Add("ProtocolVersion", r.ProtocolVersion.ToString());
					c.Add("Server", r.Server);
					c.Add("StatusCode", Convert.ToString(r.StatusCode));
					c.Add("StatusDescription", r.StatusDescription);
				}
				else if(request is FileWebRequest)
				{
				}
				return c;
			}
		}
	}
}
